/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.api.util.IOrientable;
import appeng.decorative.solid.QuartzPillarBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MetaRotation
implements IOrientable {
    private final Property<Direction> facingProp;
    private final BlockGetter level;
    private final BlockPos pos;

    public MetaRotation(BlockGetter level, BlockPos pos, Property<Direction> facingProp) {
        this.level = level;
        this.pos = pos;
        this.facingProp = facingProp;
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }

    @Override
    public Direction getForward() {
        if (this.getUp().m_122430_() == 0) {
            return Direction.UP;
        }
        return Direction.SOUTH;
    }

    @Override
    public Direction getUp() {
        BlockState state = this.level.m_8055_(this.pos);
        if (this.facingProp != null && state.m_61138_(this.facingProp)) {
            return (Direction)state.m_61143_(this.facingProp);
        }
        if (state.m_61138_(QuartzPillarBlock.AXIS)) {
            Direction.Axis a = (Direction.Axis)state.m_61143_(QuartzPillarBlock.AXIS);
            return switch (a) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> Direction.EAST;
                case Direction.Axis.Z -> Direction.SOUTH;
                case Direction.Axis.Y -> Direction.UP;
            };
        }
        return Direction.UP;
    }

    @Override
    public void setOrientation(Direction forward, Direction up) {
        if (this.level instanceof Level) {
            if (this.facingProp != null) {
                ((Level)this.level).m_46597_(this.pos, (BlockState)this.level.m_8055_(this.pos).m_61124_(this.facingProp, (Comparable)up));
            } else {
                ((Level)this.level).m_46597_(this.pos, (BlockState)this.level.m_8055_(this.pos).m_61124_(QuartzPillarBlock.AXIS, (Comparable)up.m_122434_()));
            }
        } else {
            throw new IllegalStateException(this.level.getClass().getName() + " received, expected World");
        }
    }
}

